
*The Effects of Fiscal Measures During Covid-19* 
*Pragyan Deb, Davide Furceri, Jonathan D. Ostry, Nour Tawk, Naihan Yang* 

*Figures 7 results*

*1. EFFECT OF FISCAL MEASURES ON BILATERAL EXCHANGE RATE* 

global MYDATA "C:\Users\ntawk\Desktop\JMCB final\finalforjmcb"
global SAVING "C:\Users\ntawk\Desktop\JMCB final\finalforjmcb\results" 

cd $ME
clear all
set maxvar 120000

* Load data
use "$MYDATA\daily_dta_toJMCB.dta", clear
cd "C:\Users\ntawk\Desktop\JMCB final\finalforjmcb\results"
drop zero tg

foreach shock in fp_res_frn_xer {
* fp_res_frn_xstx: fiscal shock excluding stock market in purging regression 
*fp_res_frn_xer :  fiscal shock excluding bilateral exchange rate in purging regression 
*control "close" is the VIX at close of day. 

foreach dep in er {

/*---------------------------------------------------------*/
/* Define parameters for LP                  			   */
/*---------------------------------------------------------*/

* Number of lags in LP: originally we chose 4 lags, now we text with different lag structures 
local MaxLPLags 2

* LP horizon
local horizon 30


/*---------------------------------------------------------*/
/* Baseline LP regressions                  			   */
/*---------------------------------------------------------*/

* variables to store the impulse response (vector of betas from the LP regressions) and standard errors
gen b_`dep'=0
gen se_`dep'=0
gen cb_`dep'=0
gen cse_`dep'=0

* One regression for each horizon of the response
capture erase LP_`dep'_`shock'.xml
capture erase LP_`dep'_`shock'.txt
capture erase cLP_`dep'_`shock'.xml
capture erase cLP_`dep'_`shock'.txt

forvalues i=1/`horizon' {


*baseline*
local control l(1/`MaxLPLags').(d.`dep') l(1/`MaxLPLags').(`shock') l(1/`MaxLPLags').(d.c) l(1/`MaxLPLags').(d.d) l(1/`MaxLPLags').(mes)  l(1/`MaxLPLags').(mp_gdp) l(1/`MaxLPLags').(close)  c.time#code
	
	gen y=f`i'.`dep'-l.`dep'
	
	xtreg y `shock' `control', fe cluster(code)
	outreg2 using cLP_`dep'_`shock', append title("Dependent Variable: `: var label `dep'' cumulative difference") ctitle("f`i'.`dep'") excel  
	
	scalar ssize=e(N_clust)

	replace cb_`dep'  = _b[`shock']*100 if _n == `i'+1
	replace cse_`dep' = _se[`shock']*100 if _n == `i'+1
	
	drop y

}

* Create impulse response graphs

* create x and y axis line
gen zero = 0 if _n <= `horizon' +1
gen tg = _n-1 if _n <= `horizon' +1


* Create confidence bands (in this case 90 and 70%)
scalar sig1 = 0.05	 // specify significance level
scalar sig2 = 0.25	 // specify significance level

* cumulative log difference
gen cup_`dep' = cb_`dep' + invnormal(1-sig1/2)*cse_`dep' if _n <= (`horizon' + 1)
gen cdn_`dep' = cb_`dep' - invnormal(1-sig1/2)*cse_`dep' if _n <= (`horizon' + 1)

gen cup2_`dep' = cb_`dep' + invnormal(1-sig2/2)*cse_`dep' if _n <= (`horizon' + 1)
gen cdn2_`dep' = cb_`dep' - invnormal(1-sig2/2)*cse_`dep' if _n <= (`horizon' + 1)

*for flipped ER chart* Increase= appreciation  
replace cup_`dep' = - cup_`dep' 
replace cup2_`dep'= - cup2_`dep'  
replace cdn_`dep' = - cdn_`dep' 
replace cdn2_`dep'= - cdn2_`dep'  
replace cb_`dep' = - cb_`dep'
	
	grstyle init
	grstyle set nogrid
	twoway (rarea cup_`dep' cdn_`dep'  tg, ///
	fcolor(gs12) lcolor(white) lpattern(solid)) ///
	(rarea cup2_`dep' cdn2_`dep'  tg, ///
	 fcolor(gs10) lcolor(white) lpattern(solid)) ///
	(line cb_`dep' tg, lcolor(blue) ///
	xlabel(,labsize(large)) ///
	ylabel(,labsize(large)) ///
	lpattern(solid) lwidth(thick)) /// 
	(line zero tg, lcolor(black)), ///
	title("`: var label `dep'', deviation from baseline", color(black) size(large)) ///
	xtitle("Days after announcement of fiscal packages", size(large))  ///
	graphregion(color(white)) plotregion(color(white)) ///
	legend(off) name(c`dep', replace) nodraw
	graph save   cLP_`dep'_`shock'.gph, replace


}

}
graph use cLP_er_fp_res_frn_xer
graph export cLP_er_fp_res_frn_xer.emf

* Export raw results and confidence bands for making figures
export excel tg cb_er cup_er	cdn_er	cup2_er	cdn2_er using  "$SAVING\ER_BETA CI.xls", sheet("`LHS'") sheetmodify firstrow(variables)		

drop zero tg


*2. EFFECT OF FISCAL MEASURES ON STOCK MARKET PRICES* 

foreach shock in fp_res_frn_xstx {
* fp_res_frn_xstx: fiscal shock excluding stock market in purging regression 
*fp_res_frn_xer :  fiscal shock excluding bilateral exchange rate in purging regression 


foreach dep in stx {

/*---------------------------------------------------------*/
/* Define parameters for LP                  			   */
/*---------------------------------------------------------*/

* Number of lags in LP: originally we chose 4 lags, now we text with different lag structures 
local MaxLPLags 2

* LP horizon
local horizon 30


/*---------------------------------------------------------*/
/* Baseline LP regressions                  			   */
/*---------------------------------------------------------*/

* variables to store the impulse response (vector of betas from the LP regressions) and standard errors
gen b_`dep'=0
gen se_`dep'=0
gen cb_`dep'=0
gen cse_`dep'=0

* One regression for each horizon of the response
capture erase LP_`dep'_`shock'.xml
capture erase LP_`dep'_`shock'.txt
capture erase cLP_`dep'_`shock'.xml
capture erase cLP_`dep'_`shock'.txt

forvalues i=1/`horizon' {


*baseline*
local control l(1/`MaxLPLags').(d.`dep') l(1/`MaxLPLags').(`shock') l(1/`MaxLPLags').(d.c) l(1/`MaxLPLags').(d.d) l(1/`MaxLPLags').(mes)  l(1/`MaxLPLags').(mp_gdp) l(1/`MaxLPLags').(close)  c.time#code
	
	gen y=f`i'.`dep'-l.`dep'
	
	xtreg y `shock' `control', fe cluster(code)
	outreg2 using cLP_`dep'_`shock', append title("Dependent Variable: `: var label `dep'' cumulative difference") ctitle("f`i'.`dep'") excel  
	
	scalar ssize=e(N_clust)

	replace cb_`dep'  = _b[`shock']*100 if _n == `i'+1
	replace cse_`dep' = _se[`shock']*100 if _n == `i'+1
	
	drop y

}

* Create impulse response graphs

* create x and y axis line
gen zero = 0 if _n <= `horizon' +1
gen tg = _n-1 if _n <= `horizon' +1


* Create confidence bands (in this case 90 and 70%)
scalar sig1 = 0.05	 // specify significance level
scalar sig2 = 0.25	 // specify significance level

* cumulative log difference
gen cup_`dep' = cb_`dep' + invnormal(1-sig1/2)*cse_`dep' if _n <= (`horizon' + 1)
gen cdn_`dep' = cb_`dep' - invnormal(1-sig1/2)*cse_`dep' if _n <= (`horizon' + 1)

gen cup2_`dep' = cb_`dep' + invnormal(1-sig2/2)*cse_`dep' if _n <= (`horizon' + 1)
gen cdn2_`dep' = cb_`dep' - invnormal(1-sig2/2)*cse_`dep' if _n <= (`horizon' + 1)
	
	grstyle init
	grstyle set nogrid
	twoway (rarea cup_`dep' cdn_`dep'  tg, ///
	fcolor(gs12) lcolor(white) lpattern(solid)) ///
	(rarea cup2_`dep' cdn2_`dep'  tg, ///
	 fcolor(gs10) lcolor(white) lpattern(solid)) ///
	(line cb_`dep' tg, lcolor(blue) ///
	xlabel(,labsize(large)) ///
	ylabel(,labsize(large)) ///
	lpattern(solid) lwidth(thick)) /// 
	(line zero tg, lcolor(black)), ///
	title("`: var label `dep'', deviation from baseline", color(black) size(large)) ///
	xtitle("Days after announcement of fiscal packages", size(large))  ///
	graphregion(color(white)) plotregion(color(white)) ///
	legend(off) name(c`dep', replace) nodraw
	graph save   cLP_`dep'_`shock'.gph, replace

}

}

export excel cb_stx cup_stx	cdn_stx	cup2_stx cdn2_stx using  "$SAVING\MSCI_BETA CI.xls", sheet("`LHS'") sheetmodify firstrow(variables)		

